/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.squeeze_basin;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlock;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinInventory;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezingRecipe;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRItems;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class SqueezeBasinBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public SqueezeBasinInventory inputInventory = new SqueezeBasinInventory(1, this);
    public SmartFluidTankBehaviour inputTank;
    public SqueezingRecipe lastRecipe;
    protected SmartInventory outputInventory;
    protected IItemHandlerModifiable itemCapability;
    protected IFluidHandler fluidCapability;
    int recipeBackupCheck;
    private boolean contentsChanged;

    public SqueezeBasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        }).withMaxStackSize(64);
        this.outputInventory = new SqueezeBasinInventory(1, this).forbidInsertion().withMaxStackSize(64);
        this.itemCapability = new SqueezeBasinInventoryHandler();
        this.contentsChanged = true;
        this.recipeBackupCheck = 20;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.SQUEEZE_BASIN_ENTITY.get(), (be, context) -> be.itemCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CRBlockEntityTypes.SQUEEZE_BASIN_ENTITY.get(), (be, context) -> be.fluidCapability);
    }

    public boolean hasCasing() {
        return (Boolean)this.getBlockState().getValue((Property)SqueezeBasinBlock.CASING);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.fluidCapability = this.inputTank.getCapability();
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (!this.outputInventory.isEmpty() && !this.level.isClientSide) {
            this.tryClearingSpoutputOverflow();
        }
        if (this.contentsChanged) {
            this.contentsChanged = false;
        }
        if (this.getOperator().isEmpty() || this.getProcessingSpeed() == 0.0f || this.level.isClientSide) {
            return;
        }
        if (!this.outputInventory.isEmpty()) {
            return;
        }
        PressingBehaviour behaviour = this.getOperator().get().getPressingBehaviour();
        if (behaviour.runningTicks == 120) {
            this.process();
        }
        if (behaviour.running) {
            return;
        }
        if (this.inputInventory.getStackInSlot(0).isEmpty() && this.inputTank.isEmpty()) {
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.match(this)) {
            Optional recipe = CRRecipeTypes.SQUEEZING.find(this.inputInventory, this.level);
            if (recipe.isPresent()) {
                this.lastRecipe = (SqueezingRecipe)recipe.get().value();
                if (this.lastRecipe.match(this)) {
                    this.getOperator().ifPresent(be -> be.pressingBehaviour.start(PressingBehaviour.Mode.BASIN));
                }
            }
            this.sendData();
        } else {
            if (this.lastRecipe.match(this)) {
                this.getOperator().ifPresent(be -> be.pressingBehaviour.start(PressingBehaviour.Mode.BASIN));
            }
            this.sendData();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide && this.recipeBackupCheck-- <= 0) {
            this.recipeBackupCheck = 20;
            if (!this.isEmpty()) {
                this.notifyChangeOfContents();
            }
        }
    }

    public boolean isEmpty() {
        return this.inputInventory.isEmpty() && this.outputInventory.isEmpty();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("InputItems", (Tag)this.inputInventory.serializeNBT(registries));
        compound.put("OutputItems", (Tag)this.outputInventory.serializeNBT(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inputInventory.deserializeNBT(registries, compound.getCompound("InputItems"));
        this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputItems"));
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void remove() {
        super.remove();
        this.onEmptied();
    }

    public void destroy() {
        super.destroy();
        if (this.level == null) {
            return;
        }
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInventory);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInventory);
        if (((Boolean)this.getBlockState().getValue((Property)SqueezeBasinBlock.CASING)).booleanValue()) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)new ItemStack((ItemLike)CRItems.SAUSAGE_CASING.get(), 1));
        }
    }

    public void onEmptied() {
        this.getOperator().ifPresent(be -> {
            be.basinRemoved = true;
        });
    }

    private void tryClearingSpoutputOverflow() {
        if (this.level == null) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof SqueezeBasinBlock)) {
            return;
        }
        Direction direction = (Direction)blockState.getValue((Property)SqueezeBasinBlock.FACING);
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.below().relative(direction.getOpposite()));
        InvManipulationBehaviour inserter = null;
        if (be != null) {
            inserter = (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)be.getBlockPos(), (BehaviourType)InvManipulationBehaviour.TYPE);
        }
        IItemHandler targetInv = be == null ? null : (IItemHandler)Optional.ofNullable((IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), (Object)direction.getOpposite())).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack itemStack = this.outputInventory.getStackInSlot(i);
            if (targetInv == null || !ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack, (boolean)true).isEmpty()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.copy(), (boolean)false);
            this.outputInventory.setStackInSlot(i, ItemStack.EMPTY);
            this.notifyChangeOfContents();
            this.sendData();
        }
    }

    public Optional<MechanicalPressBlockEntity> getOperator() {
        if (this.level == null) {
            return Optional.empty();
        }
        BlockEntity be = this.level.getBlockEntity(this.worldPosition.above(2));
        return be instanceof MechanicalPressBlockEntity ? Optional.of((MechanicalPressBlockEntity)be) : Optional.empty();
    }

    public float getProcessingSpeed() {
        if (this.getOperator().isPresent()) {
            MechanicalPressBlockEntity be = this.getOperator().get();
            return be.pressingBehaviour.getRunningTickSpeed();
        }
        return 0.0f;
    }

    private void process() {
        boolean useCasing;
        if (this.level == null) {
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.match(this)) {
            Optional recipe = CRRecipeTypes.SQUEEZING.find(this.inputInventory, this.level);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = (SqueezingRecipe)recipe.get().value();
        }
        if ((useCasing = this.lastRecipe.useCasing()) != (Boolean)this.getBlockState().getValue((Property)SqueezeBasinBlock.CASING)) {
            return;
        }
        if (useCasing) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SqueezeBasinBlock.CASING, (Comparable)Boolean.valueOf(false)));
        }
        if (!this.lastRecipe.getFluidIngredients().isEmpty()) {
            this.fluidCapability.drain(this.fluidCapability.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
        }
        ItemStack stackInSlot = this.inputInventory.getStackInSlot(0);
        stackInSlot.shrink(1);
        this.inputInventory.setStackInSlot(0, stackInSlot);
        this.acceptOutputs(this.lastRecipe.rollResults(this.level.random), false);
        this.notifyChangeOfContents();
        this.notifyUpdate();
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, boolean simulate) {
        this.outputInventory.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, simulate);
        this.outputInventory.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, boolean simulate) {
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof SqueezeBasinBlock)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        SmartInventory targetInv = this.outputInventory;
        if (targetInv == null) {
            return false;
        }
        return this.acceptItemOutputsIntoBasin(outputItems, simulate, (IItemHandler)targetInv);
    }

    private boolean acceptItemOutputsIntoBasin(@NotNull List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.copy(), (boolean)simulate).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("gui.goggles.squeeze_basin_contents", new Object[0]).forGoggles(tooltip);
        if (this.itemCapability == null) {
            this.itemCapability = new ItemStackHandler();
        }
        if (this.fluidCapability == null) {
            this.fluidCapability = new FluidTank(0);
        }
        boolean isEmpty = true;
        for (int i = 0; i < this.itemCapability.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemCapability.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            Lang.text("").add(Component.translatable((String)stackInSlot.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(Lang.text(" x" + stackInSlot.getCount()).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = Lang.translate("generic.unit.millibuckets", new Object[0]);
        for (int i = 0; i < this.fluidCapability.getTanks(); ++i) {
            FluidStack fluidStack = this.fluidCapability.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            Lang.text("").add(Lang.fluidName(fluidStack).add(Lang.text(" ")).style(ChatFormatting.GRAY).add(Lang.number(fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (((Boolean)this.getBlockState().getValue((Property)SqueezeBasinBlock.CASING)).booleanValue()) {
            Lang.text("").add(Component.translatable((String)((Item)CRItems.SAUSAGE_CASING.get()).getDescriptionId()).withStyle(ChatFormatting.GRAY)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            tooltip.removeFirst();
        }
        return true;
    }

    private class SqueezeBasinInventoryHandler
    extends CombinedInvWrapper {
        public SqueezeBasinInventoryHandler() {
            super(new IItemHandlerModifiable[]{SqueezeBasinBlockEntity.this.inputInventory, SqueezeBasinBlockEntity.this.outputInventory});
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (SqueezeBasinBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (SqueezeBasinBlockEntity.this.inputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (SqueezeBasinBlockEntity.this.outputInventory == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    }
}

